using System;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// Interfaced for used Pending Test Data Access Objects. Used to convert 
    /// data to their concrete types in the PendingTestHelper    
    /// </summary>
    public interface IPendingTestDao
    {
        /// <summary>
        /// PendingTestId
        /// </summary>
        int PendingTestId { get; }
        /// <summary>
        /// BloodTestTypeId
        /// </summary>
        int BloodTestTypeId { get; set; }
        /// <summary>
        /// BloodTestTypeName
        /// </summary>
        string BloodTestTypeName { get; set; }
        /// <summary>
        /// BloodTestTypeSortOrder
        /// </summary>
        short BloodTestTypeSortOrder { get; set; }
        /// <summary>
        /// TestDate
        /// </summary>
        DateTime TestDate { get; set; }
        /// <summary>
        /// TestTechId
        /// </summary>
        string TestTechId { get; set; }
        /// <summary>
        /// TestResultId
        /// </summary>
        string TestResultId { get; set; }
        /// <summary>
        /// TestTechUserName
        /// </summary>
        string TestTechUserName { get; set; }        
        /// <summary>
        /// TestResultText
        /// </summary>
        string TestResultText { get; set; }
        /// <summary>
        /// AutoInstrumentComments
        /// </summary>
        string AutoInstrumentComments { get; set; }
        /// <summary>
        /// AutoInstrumentName
        /// </summary>
        string AutoInstrumentName { get; set; }
        /// <summary>
        /// DivisionCode
        /// </summary>
        string DivisionCode { get; set; }
        /// <summary>
        /// PendingTestStatus
        /// </summary>
        byte PendingTestStatusId { get; set; }  
        /// <summary>
        /// OrderableTestId
        /// </summary>
        int OrderableTestId { get; set; }
        /// <summary>
        /// OrderableTestName
        /// </summary>
        string OrderableTestName { get; set; }
        /// <summary>
        /// BloodTestTypeTestedWith
        /// </summary>
        string BloodTestTypeTestedWith { get; set; }
        /// <summary>
        /// LastUpdateUser
        /// </summary>
        string LastUpdateUser { get; set; }
        /// <summary>
        /// RowVersion
        /// </summary>
        byte[] RowVersion { get; set; }
    }
}



